/*
 * $QNXLicenseC:
 * Copyright 2010,2012 QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable
 * license fees to QNX Software Systems before you may reproduce,
 * modify or distribute this software, or any work that includes
 * all or part of this software.   Free development licenses are
 * available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email
 * licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

#include <unistd.h>
#include <string.h>

#include "platform.h"
#include "touch.h"

#ifndef UNITTEST
#include "input/mtouch_log.h"
#endif

extern int safe_usleep(useconds_t usec);

int
cypress_platform_init(struct cypress_dev* dev)
{
    int rc;
    rc = cypress_platform_tp_init(dev);
    if (0 == rc) {
        dev->platform.tp_init = cypress_platform_tp_init;
        dev->platform.tp_reset = cypress_platform_tp_reset;
        dev->platform.tp_fini = cypress_platform_tp_fini;
    } else
        mtouch_info(dev->log_name, "Unable to initialize platform");

    return rc;
}

void
cypress_platform_fini(struct cypress_dev* dev)
{
    if (dev->platform.tp_fini) {
        dev->platform.tp_fini(dev);
    }

    dev->platform.tp_init = NULL;
    dev->platform.tp_reset = NULL;
    dev->platform.tp_fini = NULL;
    dev->platform.data = NULL;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/platform.c $ $Rev: 798438 $")
#endif
